 ; Ŀ
 ;   Df - de-fixed-position the attributes in blocks of a selected type.   
 ;   Copyright 2002, 2007 by Rocket Software Ltd.                          
 ;   Despite requests, this is not called Hump-de-Fridge.                  
 ;   Later: yes it is.                                                     
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Cici - another grdraw pattern maker.                                  
 ;   Argument: Pa, the base point.                                         
 ;   Calls Ci and Radi, returns nothing.                                   
 ; 
 (DEFUN CICI (pa / rad)
  (setq rad (/ (getvar "viewsize") 25))
 ; Ŀ
 ;   Draw two circles.                                                     
 ; 
  (ci pa (* rad 0.5) 4)
  (ci pa (* rad 0.35) 4)
 ; Ŀ
 ;   Crosslines.                                                           
 ; 
  (radi pa (* rad 0.2) rad 4 0 1)
 ; Ŀ
 ;   Radial lines.                                                         
 ; 
  (radi pa (* rad 0.25) (* rad 0.8) 4 (* pi 0.25) 1)
 ; Ŀ
 ;   Lines between rings.                                                  
 ; 
  (radi pa (* rad 0.35) (* rad 0.5) 25 0 2)
 (princ))
 ; Ŀ
 ;   Cici end.                                                             
 ; 

 ; Ŀ
 ;   Dexa - remove AbCdAttr extended data from attributes in a block       
 ;   definition.                                                           
 ;   Takes one argument, a block name.                                     
 ;   Returns nothing.                                                      
 ;                                                                         
 ;   Standard Notes: 1. Entnext returns nil after the last entity in a     
 ;                      block definition.                                  
 ;                   2. An empty block has one subentity of type Endblk.   
 ;                                                                         
 ; 
 (DEFUN DEXA (namm / enam entt)
  (setq enam (cdr (assoc -2 (tblsearch "block" namm))))
  (while enam
         (setq entt (entget enam))
         (if (= (cdr (assoc 0 entt)) "ATTDEF")
             (exkill enam "AcDbAttr"))
         (setq enam (entnext enam)))
 (princ))
 ; Ŀ
 ;   Dexa end.                                                             
 ; 

 ; Ŀ
 ;   Exkill - remove the extended data from an entity.                     
 ;   Amazingly, this works: remove everything from the xdata for the       
 ;   app in question except the app name, entmod it back in, acad          
 ;   ditches the entire app xdata set from that entity.                    
 ;   Completely removing the xdata for that app doesn't work - acad        
 ;   assumes that it isn't touching the xdata for that app at all.         
 ;                                                                         
 ;   Arguments: Enam - the entity name.                                    
 ;              appi - the application to remove the data for.             
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN EXKILL (enam appi / entt exdat sub nuex)
  (setq entt (entget enam (list "*")))
  (if (setq exdat (assoc -3 entt))
      (progn
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (if (and (= (type sub) 'LIST)
                           (= (car sub) appi))
                      (setq nuex (append nuex (list (list (car sub)))))
                      (setq nuex (append nuex (list sub)))))
           (entmod (append (entget enam) (list nuex)))))
 (princ))
 ; Ŀ
 ;   Exkill end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Radi - grdraw radial line set maker.                       
 ;   Does a complete circular set.                                         
 ;   Arguments: Pa, the base point.                                        
 ;              Rin, near end distance.                                    
 ;              Rout, far end distance.                                    
 ;              Reps, number of repetions in 360 degrees.                  
 ;              Stang, the start angle.                                    
 ;              Colo, the colour.                                          
 ;   Calls its mother, returns the empties.                                
 ;                                                                         
 ; 
 (DEFUN RADI (pa rin rout reps stang colo / pa1 pa2)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq pa1 (polar pa stang rin))
          (setq pa2 (polar pa stang rout))
          (grdraw pa1 pa2 colo)
          (setq stang (+ stang incr)))
 (princ))
 ; Ŀ
 ;   Radi end.                                                             
 ; 

 ; Ŀ
 ;   Hump-de-Fridge - for the purist.                                      
 ; 
 (DEFUN C:HUMP-DE-FRIDGE ()
  (c:df)
 (princ))

 ; Ŀ
 ;   Df.                                                                   
 ; 
 (DEFUN C:DF (/ *error enam blnam ss num entt)
  (defun *error* (shk)
   (write-line shk)
  (princ))
  (setq enam (car (entsel "Block in which to de-fixed-position attributes: ")))
  (setq blnam (cdr (assoc 2 (entget enam))))
  (princ blnam)
  (dexa blnam)
  (setq ss (ssget "x" (list (cons 2 blnam))))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                (exkill enam "AcDbAttr")
                (cici (cdr (assoc 10 entt)))))
 (princ))